function test_suite = testSort %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
[p,ix] = sort(polysym.empty);
assertEqual(p,polysym.empty)
assertEqual(ix,double.empty)

function testDefault
[p,ix] = sort(polysym);
assertEqual(p,polysym)
assertEqual(ix,1)

function testZeros
x = polysym([0 0]);
[p,ix] = sort(x);
assertEqual(p,x);
assertEqual(ix,[1 2])

function testSortReverseVector
x = polysym(3:-1:1);
[p,ix] = sort(x);
assertEqual(p,fliplr(x));
assertEqual(ix,[3 2 1])

function testMixedNumericAlphabetic
x = polysym({1, 'x', 2, 'y'});
[p,ix] = sort(x);
assertEqual(p,x(ix));
assertEqual(ix,[1 3 2 4])

function testMatrix
x = polysym(eye(2));
[p,ix] = sort(x);
assertEqual(ix,[2 1; 1 2])
psort = polysym(zeros(2));
for j = 1:2
    psort(:,j) = x(ix(:,j),j);
end
assertEqual(psort,p)
